<!-- markdownlint-disable first-line-h1 -->
### Deprecations and warnings

#### HIP Perl scripts deprecation

The `hipcc` and `hipconfig` Perl scripts are deprecated. In a future release, compiled binaries will be
available as `hipcc.bin` and `hipconfig.bin` as replacements for the Perl scripts.

:::{note}
There will be a transition period where the Perl scripts and compiled binaries are available  before the
scripts are removed. There will be no functional difference between the Perl scripts and their compiled
binary counterpart. No user action is required. Once these are available, users can optionally switch to
`hipcc.bin` and `hipconfig.bin`. The `hipcc`/`hipconfig` soft link will be assimilated to point from
`hipcc`/`hipconfig` to the respective compiled binaries as the default option.
:::

#### `hipcc` options deprecation

The following `hipcc` options are being deprecated and will be removed in a future release:

* The `--amdgpu-target` option is being deprecated, and user must use the `–offload-arch` option to
  specify the GPU architecture.
* The `--amdhsa-code-object-version` option is being deprecated.  Users can use the Clang/LLVM
  option `-mllvm -mcode-object-version` to debug issues related to code object versions.
* The `--hipcc-func-supp`/`--hipcc-no-func-supp` options are being deprecated, as the function calls
  are already supported in production on AMD GPUs.

### Known issues

Under certain circumstances typified by high register pressure, users may encounter a compiler abort
with one of the following error messages:

* > `error: unhandled SGPR spill to memory`

* > `cannot scavenge register without an emergency spill slot!`

* > `error: ran out of registers during register allocation`

This is a known issue and will be fixed in a future release.
