<!-- markdownlint-disable first-line-h1 -->
### Defect fixes

The following defects are fixed in the ROCm v5.0.2 release.

#### Issue with hostcall facility in HIP runtime

In ROCm v5.0, when using the “assert()” call in a HIP kernel, the compiler may sometimes fail to emit
kernel metadata related to the hostcall facility, which results in incomplete initialization of the hostcall
facility in the HIP runtime. This can cause the HIP kernel to crash when it attempts to execute the
“assert()” call.

The root cause was an incorrect check in the compiler to determine whether the hostcall facility is
required by the kernel. This is fixed in the ROCm v5.0.2 release.

The resolution includes a compiler change, which emits the required metadata by default, unless the
compiler can prove that the hostcall facility is not required by the kernel. This ensures that the
“assert()” call never fails.

:::{note}
This fix may lead to breakage in some OpenMP offload use cases, which use print inside a target region
and result in an abort in device code. The issue will be fixed in a future release.
:::

The compatibility matrix in the [Deep-learning guide](./how-to/deep-learning-rocm.md) is updated for
ROCm v5.0.2.
