<head>
  <meta charset="UTF-8">
  <meta name="description" content="ROCm governance model">
  <meta name="keywords" content="ROCm, governance">
</head>

# Governance model

ROCm is a software stack made up of a collection of drivers, development tools, and APIs that enable
GPU programming from the low-level kernel to end-user applications.

Components of ROCm that are inherited from external projects (such as
[LLVM](https://github.com/ROCm/llvm-project) and
[Kernel driver](https://github.com/ROCm/ROCK-Kernel-Driver)) follow their own
governance model and code of conduct. All other components of ROCm are governed by this
document.

## Governance

ROCm is led and managed by AMD.

We welcome contributions from the community. Our maintainers review all proposed changes to
ROCm.

## Roles

* **Maintainers** are responsible for their designated component and repositories.
* **Contributors** provide input and suggest changes to existing components.

### Maintainers

Maintainers are appointed by AMD. They are able to approve changes and can commit to our
repositories. They must use pull requests (PRs) for all changes.

You can find the list of maintainers in the CODEOWNERS file of each repository. Code owners differ
between repositories.

### Contributors

If you're not a maintainer, you're a contributor. We encourage the ROCm community to contribute in
several ways:

* Help other community members by posting questions or solutions on our
  [GitHub discussion forums](https://github.com/ROCm/ROCm/discussions)
* Notify us of a bugs by filing an issue report on
  [GitHub Issues](https://github.com/ROCm/ROCm/issues)
* Improve our documentation by submitting a PR to our
  [repository](https://github.com/ROCm/ROCm/)
* Improve the code base (for smaller or contained changes) by submitting a PR to the component
* Suggest larger features by adding to the *Ideas* category in the
  [GitHub discussion forum](https://github.com/ROCm/ROCm/discussions)

For more information, refer to our [contribution guidelines](CONTRIBUTING.md).

## Code of conduct

To engage with any AMD ROCm component that is hosted on GitHub, you must abide by the
[GitHub community guidelines](https://docs.github.com/en/site-policy/github-terms/github-community-guidelines)
and the
[GitHub community code of conduct](https://docs.github.com/en/site-policy/github-terms/github-community-code-of-conduct).
