# gpu-isolation-tools

This builds a number of packages with utilities that facilitate working with
GPUs in environments isolated from the host system. Currently, GPUs from
AMD and NVIDIA are supported.

This currently builds two packages:

- **gpuisol-qemu**
- **gpuisol-podman**

## gpuisol-qemu

These are utilities for working with GPUs inside QEMU VMs:

- **gpuisol-qemu-setup**
  Prepare the system for GPU pass-through
- **gpuisol-qemu-create**
  Build QEMU images with GPU pass-through support
- **gpuisol-qemu-run**
  Boot a VM with GPU pass-through
- **autopkgtest-virt-qemu+rocm**
  autopkgtest backend that extends the regular `qemu` backend with automatic
  setup of AMD GPU pass-through
- **autopkgtest-virt-qemu+cuda**
  autopkgtest backend that extends the regular `qemu` backend with automatic
  setup of NVIDIA GPU pass-through

## gpuisol-podman

These are utilities for working with GPUs inside Podman containers:

- **gpuisol-podman-setup**
  Prepare the system for GPU-in-container use
- **gpuisol-podman-create**
  Build podman images with GPU support
- **gpuisol-podman-run**
  Run a command in a container with GPU support
- **autopkgtest-virt-podman+cuda**
  autopkgtest backend that extends the regular `podman` backend with automatic
  setup of AMD GPU devices and subuid mappings.
- **autopkgtest-virt-podman+rocm**
  autopkgtest backend that extends the regular backend with automatic setup
  of NVIDIA GPU devices and subuid mappings.

## Examples

These examples use AMD GPUs. Replace `rocm` with `cuda` for NVIDIA GPUs.

### QEMU

```shell
# Run setup to determine what changes your system and your user needs
$ gpuisol-qemu-setup rocm

# Alternatively, if you want to check the setup for some other user
$ gpuisol-qemu-setup -u somename rocm


# Create an image for unstable
$ gpuisol-qemu-create rocm-unstable.img

# Live above, but include an SSH key
$ sudo gpuisol-qemu-create -a /path/to/authorized_keys

# Create image for bookworm, using a fast local mirror
$ sudo gpuisol-qemu-create -r bookworm -m http://10.1.2.3:9999/debian rocm-bookworm.img


# Run rocrand's autopkgtests (from the official archive) using that image
$ autopkgtest -B rocrand -- qemu+rocm rocm-unstable.img

# By default, the qemu+rocm backend will claim 75% of host cores and RAM. Use
# --cpus and --ram-size to adjust:
$ autopkgtest -B rocrand -- qemu+rocm --cpus 4 --ram-size 16384 rocm-unstable.img

# Run rocrand's autopkgtest, passing in only the GPU at 2b:00.0
$ autopkgtest -B rocrand -- qemu+rocm --gpu 2b:00.0 rocm-unstable.img


# Boot into the image if you need to, here with a shared directory
$ gpuisol-qemu-run -d /dir/on/host rocm-unstable.img

# If the stack name cannot be deduced from the image name, pass it explicitly
$ gpuisol-qemu-run -d /dir/on/host -t rocm unstable.img
```

### Podman

```shell
# Run setup to determine what changes your system and your user needs
$ gpuisol-podman-setup rocm

# Alternatively, if you want to check the setup for some other user
$ gpuisol-podman-setup -u somename rocm


# Create an image for unstable. Stack must be the first argument
$ gpuisol-podman-create rocm myimage


# Run rocrand's autopkgtests (from the official archive) using that image
$ autopkgtest -B rocrand -- podman+rocm myimage


# Run a container as if you would with 'podman run', but prepending the stack
# name
$ gpuisol-podman-run rocm --rm -it myimage

# If the image is tagged 'rocm/...' or 'cuda/...', prepending the stack name
# can be omitted
$ gpuisol-podman-run --rm -it rocm/myimage.img
```
