#!/bin/sh

set -eu

base=$(readlink -f "$(dirname "$(readlink -f "$0")")/../..")
. "$base/lib/environment.sh"

prepare_args
rootfs="$1"

# convert apt proxy pointing to the VM's host back to localhost
proxy_opt=
RES=$(chroot "${rootfs}" apt-config shell PROXY Acquire::http::Proxy)
eval "$RES"
if [ -n "${PROXY:-}" ]; then
  proxy_opt="-o Acquire::http::Proxy=$(echo "${PROXY}" | sed -e 's/10.0.2.2/127.0.0.1/')"
fi
# shellcheck disable=SC2086
DEBIAN_FRONTEND=noninteractive \
  chroot "$rootfs"  \
  apt-get install $proxy_opt dpkg-dev ca-certificates -q -y --no-install-recommends
if chroot "$rootfs" apt-cache show auto-apt-proxy >/dev/null 2>&1; then
  # shellcheck disable=SC2086
  DEBIAN_FRONTEND=noninteractive \
    chroot "$rootfs"  \
    apt-get install $proxy_opt auto-apt-proxy -q -y --no-install-recommends
fi

# ci.ai.debian.net: NVIDIA GPUs require the DKMS driver

distro_name="$(. "$rootfs/etc/os-release"; echo "${NAME% *}")"
case "$distro_name" in
# FIXME
#  Ubuntu)
#    firmware_pkg=linux-firmware
#	;;
  *)
    extra_packages="nvidia-kernel-dkms linux-headers-amd64 nvidia-driver-bin nvidia-driver-libs"
	;;
esac
DEBIAN_FRONTEND=noninteractive \
  chroot "$rootfs"  \
  apt-get install $proxy_opt $extra_packages pciutils -q -y --no-install-recommends

DEBIAN_FRONTEND=noninteractive \
  chroot "$rootfs"  \
  apt-get clean

# ci.ai.debian.net: User 'debci' must be in the video and render groups
cat > "$rootfs"/etc/sysctl.d/rocm-dmesg.conf <<EOF
# Created by the Debian Deep Learning Team's qemu+cuda backend for debci
kernel.dmesg_restrict=0
EOF

mkdir -m 0755 "$rootfs/dri"
cat >> "$rootfs"/etc/fstab <<EOF
# Added by the Debian Deep learning Team's qemu+cuda backend for debci
/sys/kernel/debug/dri /dri none defaults,bind 0 0
EOF

chroot "$rootfs"  \
  useradd \
    --home /home/debci \
    --create-home \
    --groups audio,video,render \
    debci
